<!DOCTYPE html>
<html lang="en">
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ProteusNet">
    <link rel="icon" type="image/ico" href="images/favicon.png">
    <title>Meru Lending - Best Rates, Best Services</title>

    <!-- Custom styles for this template -->
    <!-- build:css stylesheets/main.css -->
    <link href="stylesheets/bootstrap.css" rel="stylesheet">
    <link href="stylesheets/main.css" rel="stylesheet">
    <!-- endbuild -->

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->

    <!-- Google fonts -->
    <script type="text/javascript">
      WebFontConfig = {
        google: { families: [ 'Arvo:700:latin', 'Open+Sans:400,600,700:latin' ] }
      };
      (function() {
        var wf = document.createElement('script');
        wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
          '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
        wf.type = 'text/javascript';
        wf.async = 'true';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(wf, s);
      })();
    </script>
    </head>
    <body>
<div class="top  js--fixed-header-offset">
      <div class="container">
    <div class="row">
          <div class="col-xs-12  col-sm-6">
        <div class="top__slogan"> For Best Rate,  Best Service! <small><span class="glyphicon  glyphicon-heart  tertiary-color"></span></small> </div>
      </div>
          <div class="col-xs-12  col-sm-6">
        <div class="top__menu"> </div>
      </div>
        </div>
  </div>
    </div>
    
    
<header class="header  js--navbar">
      <div class="container">
    <div class="row">
          <div class="col-xs-10  col-md-3">
        <div class="header-logo"> <a href="index.php"><img class="push-down-20" alt="Footer Logo" src="images/logo-footer.png" ></a></div>
      </div>
          <div class="col-xs-2  visible-sm  visible-xs"> 
        <!-- Brand and toggle get grouped for better mobile display -->
        <div class="navbar-header">
              <button type="button" class="navbar-toggle  collapsed" data-toggle="collapse" data-target="#collapsible-navbar"> <span class="sr-only">Toggle navigation</span> <span class="icon-bar"></span> <span class="icon-bar"></span> <span class="icon-bar"></span> </button>
            </div>
      </div>
          <div class="col-xs-12  col-md-7">
        <nav class="navbar  navbar-default" role="navigation"> 
              <!-- Collect the nav links, forms, and other content for toggling -->
              <div class="collapse  navbar-collapse" id="collapsible-navbar">
            <ul class="nav  navbar-nav">
                  <li class="dropdown"><a href="rates.php">BEST MORTGAGE RATES</a></li>
                  <li class="dropdown"><a href="http://www.relitrust.org/" target="_blank">Full Site</a></li>
                </ul>
          </div>
              <!-- /.navbar-collapse --> 
            </nav>
      </div>
        </div>
  </div>
    </header>
<div class="breadcrumbs">
  <div class="container">
    <div class="row">
      <div class="col-xs-12">
        <nav>
          <ol class="breadcrumb">
            
            <li><a href="index.html">Home</a></li>
            <li class="active">Meru Lending: Mortgage Rates</li>
            
          </ol>
        </nav>
      </div>
    </div>
  </div>
</div>    
    
<div class="container">
	<div class="row">
		
    
        <div class="col-xs-12 col-md-12">


<?php
      error_reporting(0);
      $loanType = trim($_REQUEST['loanType']);
      $homeType = trim($_REQUEST['homeType']);	  
      $propertyType = trim($_REQUEST['propertyType']);
	  
      $salePrice = trim($_REQUEST['salePrice']);
      $rateInput = trim($_REQUEST['rateInput']);	 
      $paymentAmount = trim($_REQUEST['paymentAmount']);
      $loanAmount = trim($_REQUEST['loanAmount']); 	
      $zip = trim($_REQUEST['zip']);	
	  
	  //validate required fields
		$errors = array();		
		if($loanType != "Purchase" && $loanType != "Refinance" && $loanType != "Cash out refinance") {
			$errors[] = 'Loan Type';
		}

		if($homeType != "Primary Residence" && $homeType != "Investment Property") {
			$errors[] = 'Home Type';
		}		

		if($propertyType != "Single Family" && $propertyType != "Townhouse" && $propertyType != "Condominium") {
			$errors[] = 'Property Type';
		}
		
		if(empty($salePrice)) {
			$errors[] = 'Property Sale Price';
		}

		if(empty($loanAmount)) {
			$errors[] = 'Loan Amount';
		}

		if(empty($rateInput)) {
			$errors[] = 'Percent of down payment';
		}		

		if(empty($paymentAmount)) {
			$errors[] = 'Amount of payment';
		}
		
		if(empty($zip) || !preg_match('/^[0-9]{5}$/', $zip)) {
			$errors[] = 'Zip Code';
		}

        if($errors) {
                    echo '<h1 class="center"><span class="light">Oops! </span>There appears to be a problem with your form input<br />on the other page...</h1><hr class="divider">';
                    echo '<p><strong>Please click the Back Button</strong> and correct the following error(s):</p><ul>';
                    
                    foreach ($errors as $e) {
                        echo "<li>Please enter a valid $e.</li>\n";
                    }
        
                    echo '</ul>';
                } else {
        ?>
            </div>
	</div>
</div>
    
        
    
<div class="container  push-down-30">
	<div class="row">
        <div class="col-xs-12 col-md-4 light-paper-pattern">
                                          <h1 class="testimonials__title center"><span class="light">Our Clients</span> Feedback</h1>
                                          
                                         
                                        <div class="carousel-inner">
                                             
                                              <div class="item active"> <q class="testimonials__text">I picked Meru Lending because they have best rate. <br>
                                                I refer my  friends because they kept me informed through out the loan process</q><br>
                                            <br>
                                            <cite>– <b> B. Mathew ,</b></cite> Frisco TX </div>
                                            </div>
                                      
                                       <hr class="divider-dark">
                                        </div>                    
        <div class="col-xs-12 col-md-8">
                                  <h1 class="center"><span class="light">Get the best </span>Mortgage Rate</h1>
                                  <h4 class="center"><span class="light">Step 3 of 3 </span></h4>
                                  <hr class="divider">
                                  <div class="push-down-30"></div>
                                  <form validate method="post" action="confirmation.php" role="form">
                                <div class="row">
                                      
                                      <div class="col-xs-12  col-sm-12">
                                    
                                    
                                    <div class="form-group">
                                          <label class="text-dark" for="firstName">First Name <span class="warning"></span></label>
                                          <input type="text" id="firstName" name="firstName" class="form-control  form-control--contact" required autocomplete="on">
                                        </div>
                                    <div class="form-group">
                                          <label class="text-dark" for="lastName">Last Name <span class="warning"></span></label>
                                          <input type="text" id="lastName" name="lastName" class="form-control  form-control--contact" required autocomplete="on">
                                        </div>
                                    <div class="form-group">
                                          <label class="text-dark" for="email">E-mail <span class="warning"></span></label>
                                          <p class="text-right small"> <i class="glyphicon glyphicon-info-sign tertiary-color"> </i> john@gmail.com</p>
                                          <input type="email" name="email" id="email" class="form-control  form-control--contact" required placeholder="email@address" autocomplete="on">
                                        </div>
                                    <div class="form-group">
                                          <label class="text-dark" for="phone">Phone <span class="warning"></span></label>
                                          <p class="text-right small"><i class="glyphicon glyphicon-info-sign tertiary-color"> </i> 888-888-8888</p>
                                          <input type="tel" name="phone" id="phone" class="form-control  form-control--contact" required autocomplete="on">
                                        </div>
                                    <hr>
                                    <div class="right">
                                          <button type="submit" class="btn  btn-warning">Send Free Quote</button>
                                        </div>
                                    <br />
                                  </div>
                                      <div class="col-xs-1  col-sm-3"></div>
                                    </div>
                                <input type="hidden" name="loanType" value="<?php echo $loanType; ?>">
                                <input type="hidden" name="homeType" value="<?php echo $homeType; ?>">
                                <input type="hidden" name="propertyType" value="<?php echo $propertyType; ?>">
                                <input type="hidden" name="loanAmount" value="$<?php echo $loanAmount; ?>">
                                <input type="hidden" name="rateInput" value="<?php echo $rateInput; ?>%">
                                <input type="hidden" name="paymentAmount" value="$<?php echo $paymentAmount; ?>">
                                <input type="hidden" name="salePrice" value="<?php echo $salePrice; ?>">
                                <input type="hidden" name="zip" value="<?php echo $zip; ?>">
                              </form>
                                  <?php
                                }
                        ?>
                                </div>            
	</div>
</div>





<section id="footer">
      <footer class="js--page-footer">
    <div class="footer-widgets">
          <div class="container">
        <div class="row">
              <div class="col-xs-12  col-sm-6">
            <div class="footer-widgets__social"> <img class="push-down-20" alt="Footer Logo" src="images/logo-footer.png" >
                  <p> We at Meru Lending Mortgage are committed to helping you find the right mortgage product enabling you to make sound financial choices.</p>
                  <p class="tertiary-color footer__link">NMLS# <span class="tertiary-color bold">1190717</span></p>
                  <img class="push-down-10" alt="Equal Housing Lender Logo" src="images/logo-equal-fair-housing-lender.png" width="40px" > </div>
          </div>
              <div class="col-xs-12  col-sm-6">
            <div class="footer-widgets__navigation">
                  <div class="footer-wdgets__heading--line">
                <h4 class="footer-widgets__heading">Contact Us</h4>
              </div>
                  <a class="footer__link" >Meru Lending</a><br>
                  7800 Preston Road, Suite: 111 Plano, TX 75024<br>
                  <br>
                  <span class="glyphicon glyphicon-earphone glyphicon--footer"></span><a class="footer__link" > 972-312-8959</a><br>
                  <span class="glyphicon glyphicon-file glyphicon--footer"></span><a class="footer__link" > 469-814-0420 </a> (Fax)<br>
                  <span class="glyphicon glyphicon-envelope glyphicon--footer"></span><a class="footer__link" > <a href="mailto:loan@ReliTrust.com ">mail us</a></a> </div>
          </div>
            </div>
      </div>
        </div>
    <div class="footer">
          <div class="container">
        <div class="row">
              <div class="col-xs-12  col-sm-6">
            <div class="footer__text--link"> <a class="footer__link">Meru Lending</a> &copy; Copyright. All rights reserved. </div>
          </div>
              
            </div>
      </div>
        </div>
  </footer>
    </section>

<style>
		.dollar { margin-top: 6px;font-size: 18px; }
		.inline { display: inline; }
		.width-65 { width: 65%; }
		.width-80 { width: 80%; }
		.width-90 { width: 90%; }
	</style>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
<script data-main="scripts/main" src="bower_components/requirejs/require.js"></script> 
<script type="text/javascript">
	var salePrice, actualDownPayment, productSalesPricePercentage, percentDownPayment, loanAmount;

	$('#salePrice, #rateInput').on('input',function() {
		calculateDownPayment();
	});


	function calculateDownPayment() {		
		salePrice = parseFloat($('#salePrice').val().replace(/,/g, ''));
		percentDownPayment = parseFloat($('#rateInput').val()/100);
		productSalesPricePercentage = salePrice * percentDownPayment;
		actualDownPayment = productSalesPricePercentage;
		loanAmount = salePrice - actualDownPayment;
		
		$('#paymentAmount').val(formatNumber(actualDownPayment, 0, 0, true));
		$('#loanAmount').val(formatNumber(loanAmount, 0, 0, true));
	}

	function updateTextInput(val) {
		document.getElementById('rateInput').value=val; 
	}

	function formatNumber(number, digits, decimalPlaces, withCommas) {
		number = number.toString();
		var simpleNumber = '';

		// Strips out the dollar sign and commas.
		for (var i = 0; i < number.length; ++i) {
			if ("0123456789.".indexOf(number.charAt(i)) >= 0)
				simpleNumber += number.charAt(i);
		}

		number = parseFloat(simpleNumber);

		if (isNaN(number))      number     = 0;
		if (withCommas == null) withCommas = false;
		if (digits     == 0)    digits     = 1;

		var integerPart = (decimalPlaces > 0 ? Math.floor(number) : Math.round(number));
		var string      = "";

		for (var i = 0; i < digits || integerPart > 0; ++i) {
			// Insert a comma every three digits.
			if (withCommas && string.match(/^\d\d\d/))
				string = "," + string;

			string      = (integerPart % 10) + string;
			integerPart = Math.floor(integerPart / 10);
		}

		if (decimalPlaces > 0) {
			number -= Math.floor(number);
			number *= Math.pow(10, decimalPlaces);

			string += "." + formatNumber(number, decimalPlaces, 0);
		}
		
		return string;
	}
</script>
<script>
      (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
      (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
      m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
      })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

      ga('create', 'UA-33538073-8', 'proteusthemes.com');
      ga('send', 'pageview');

    </script>
</body>
</html>